package joyfill2.image.internal

import joyfill2.image.ImageCell
import joyfill2.image.ImageColumn
import joyfill2.image.ImageSchema
import joyfill2.utils.Attachment
import joyfill2.utils.JsonList
import joyfill2.utils.internal.AttachmentImpl

@PublishedApi
internal class ImageCellImpl(
    override val column: ImageColumn,
    private val wrapped: MutableMap<String, Any?>
) : ImageCell, ImageSchema by column {
    override val value: MutableList<Attachment> by lazy {
        val key = column.id
        if (wrapped[key] !is List<*>) {
            wrapped[key] = mutableListOf<MutableMap<String, Any>>()
        }
        JsonList(wrapped[key]) {
            AttachmentImpl(it)
        }
    }

    override val multi: Boolean = column.multi
}