package joyfill2.conditions.internal.field

import joyfill2.conditions.field.FieldConditionDefinition
import joyfill2.conditions.field.FieldLogic
import joyfill2.conditions.internal.AbstractLogicImpl
import joyfill2.utils.JsonList

@PublishedApi
internal class FieldLogicImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractLogicImpl(wrapped), FieldLogic {
    override val conditions: MutableList<FieldConditionDefinition> = run {
        val key = FieldLogic::conditions.name
        if (wrapped[key] == null) {
            wrapped[key] = mutableListOf<MutableMap<String, Any?>>()
        }
        JsonList(wrapped[key]) { FieldConditionDefinitionImpl(it) }
    }
}
