package joyfill2.collection.internal

import joyfill2.Field
import joyfill2.conditions.field.FieldLogic
import joyfill2.conditions.table.TableLogic
import joyfill2.conditions.internal.table.TableLogicImpl
import joyfill2.schemas.internal.AbstractSchema
import joyfill2.table.Column
import joyfill2.table.TableSchema
import joyfill2.toColumn
import joyfill2.utils.COLUMNS
import joyfill2.utils.JsonList

@PublishedApi
internal class TableSchemaImpl(
    override var id: String,
    wrapped: MutableMap<String, Any?>
) : AbstractSchema(wrapped), TableSchema {
    override var root: Boolean
        get() = wrapped[TableSchema::root.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[TableSchema::root.name] = value
        }

    override var columns: MutableList<Column>
        get() = JsonList(wrapped[COLUMNS]) { it.toColumn() }
        set(value) {
            wrapped[COLUMNS] = value
        }

    override var children: MutableList<String>
        get() = wrapped[TableSchema::children.name] as? MutableList<String> ?: mutableListOf()
        set(value) {
            wrapped[TableSchema::children.name] = value
        }

    override val tableLogic: TableLogic? get() = wrapped[Field::logic.name]?.let { TableLogicImpl(it as MutableMap<String, Any?>) }
}