package joyfill2

import joyfill2.barcode.BarcodeColumn
import joyfill2.barcode.BarcodeField
import joyfill2.barcode.internal.BarcodeCellImpl
import joyfill2.barcode.internal.BarcodeColumnImpl
import joyfill2.barcode.internal.BarcodeFieldImpl
import joyfill2.block.BlockColumn
import joyfill2.block.BlockField
import joyfill2.collection.CollectionField
import joyfill2.collection.TableSchemas
import joyfill2.collection.internal.CollectionFieldImpl
import joyfill2.collection.internal.TableSchemasImpl
import joyfill2.components.ComponentSchema
import joyfill2.dropdown.DropdownColumn
import joyfill2.dropdown.DropdownField
import joyfill2.dropdown.internal.DropdownCellImpl
import joyfill2.dropdown.internal.DropdownColumnImpl
import joyfill2.dropdown.internal.DropdownFieldImpl
import joyfill2.file.FileColumn
import joyfill2.file.FileField
import joyfill2.file.internal.FileCellImpl
import joyfill2.file.internal.FileColumnImpl
import joyfill2.file.internal.FileFieldImpl
import joyfill2.image.ImageColumn
import joyfill2.image.ImageField
import joyfill2.image.internal.ImageCellImpl
import joyfill2.image.internal.ImageColumnImpl
import joyfill2.image.internal.ImageFieldImpl
import joyfill2.internal.DocumentImpl
import joyfill2.internal.FieldPositionImpl
import joyfill2.internal.FileImpl
import joyfill2.internal.PageImpl
import joyfill2.multi_select.MultiSelectColumn
import joyfill2.multi_select.MultiSelectField
import joyfill2.multi_select.internal.MultiSelectCellImpl
import joyfill2.multi_select.internal.MultiSelectColumnImpl
import joyfill2.multi_select.internal.MultiSelectFieldImpl
import joyfill2.number.NumberColumn
import joyfill2.number.NumberField
import joyfill2.number.internal.NumberCellImpl
import joyfill2.number.internal.NumberColumnImpl
import joyfill2.number.internal.NumberFieldImpl
import joyfill2.table.Cell
import joyfill2.table.Cells
import joyfill2.table.Column
import joyfill2.table.Row
import joyfill2.table.TableField
import joyfill2.table.TableSchema
import joyfill2.table.internal.CellsImpl
import joyfill2.table.internal.RowImpl
import joyfill2.table.internal.TableFieldImpl
import joyfill2.table.internal.column.ColumnVisualPropertiesImpl
import joyfill2.table.internal.table.ColumnVisualProperties
import joyfill2.text.TextColumn
import joyfill2.text.TextField
import joyfill2.block.internal.BlockCellImpl
import joyfill2.block.internal.BlockColumnImpl
import joyfill2.block.internal.BlockFieldImpl
import joyfill2.date.DateColumn
import joyfill2.date.DateField
import joyfill2.date.internal.DateCellImpl
import joyfill2.date.internal.DateColumnImpl
import joyfill2.date.internal.DateFieldImpl
import joyfill2.signature.SignatureColumn
import joyfill2.signature.SignatureField
import joyfill2.signature.internal.SignatureCellImpl
import joyfill2.signature.internal.SignatureColumnImpl
import joyfill2.signature.internal.SignatureFieldImpl
import joyfill2.text.internal.TextCellImpl
import joyfill2.text.internal.TextColumnImpl
import joyfill2.text.internal.TextFieldImpl
import joyfill2.text_area.TextAreaColumn
import joyfill2.text_area.TextAreaField
import joyfill2.text_area.internal.TextAreaCellImpl
import joyfill2.text_area.internal.TextAreaColumnImpl
import joyfill2.text_area.internal.TextAreaFieldImpl
import joyfill2.unknown.UnknownColumn
import joyfill2.unknown.internal.UnknownCellImpl
import joyfill2.unknown.internal.UnknownColumnImpl
import joyfill2.unknown.internal.UnknownFieldImpl
import joyfill2.utils.toMap
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonArray
import kotlinx.serialization.json.JsonObject

// Document
inline fun MutableMap<String, Any?>.toDocument(): Document = DocumentImpl(this)

inline fun String.toDocuments(): List<Document> = Json.decodeFromString<JsonArray>(this).map {
    (it as JsonObject).toDocument()
}

inline fun String.toDocument(): Document = Json.decodeFromString<JsonObject>(this).toDocument()

inline fun JsonObject.toDocument(): Document = toMap().toDocument()

// Page
inline fun MutableMap<String, Any?>.toPage(): Page = PageImpl(this)

// File
inline fun MutableMap<String, Any?>.toFile(): File = FileImpl(this)

// Field
inline fun MutableMap<String, Any?>.toTextField(): TextField = TextFieldImpl(this)

inline fun MutableMap<String, Any?>.toBlockField(): BlockField = BlockFieldImpl(this)

inline fun MutableMap<String, Any?>.toTextAreaField(): TextAreaField = TextAreaFieldImpl(this)

inline fun MutableMap<String, Any?>.toBarcodeField(): BarcodeField = BarcodeFieldImpl(this)

inline fun MutableMap<String, Any?>.toNumberField(): NumberField = NumberFieldImpl(this)

inline fun MutableMap<String, Any?>.toDateField(): DateField = DateFieldImpl(this)

inline fun MutableMap<String, Any?>.toSignatureField(): SignatureField = SignatureFieldImpl(this)

inline fun MutableMap<String, Any?>.toDropdownField(): DropdownField = DropdownFieldImpl(this)

inline fun MutableMap<String, Any?>.toImageField(): ImageField = ImageFieldImpl(this)

inline fun MutableMap<String, Any?>.toFileField(): FileField = FileFieldImpl(this)

inline fun MutableMap<String, Any?>.toMultiSelectField(): MultiSelectField = MultiSelectFieldImpl(this)

inline fun MutableMap<String, Any?>.toTableField(): TableField = TableFieldImpl(this)

inline fun MutableMap<String, Any?>.toCollectionField(): CollectionField = CollectionFieldImpl(this)

inline fun MutableMap<String, Any?>.toField(): Field = when (type()) {
    Type.text -> toTextField()
    Type.block -> toBlockField()
    Type.textarea -> toTextAreaField()
    Type.dropdown -> toDropdownField()
    Type.barcode -> toBarcodeField()
    Type.number -> toNumberField()
    Type.table -> toTableField()
    Type.collection -> toCollectionField()
    Type.image -> toImageField()
    Type.file -> toFileField()
    Type.multiSelect -> toMultiSelectField()
    Type.date -> toDateField()
    Type.signature -> toSignatureField()
    else -> UnknownFieldImpl(this)
}

inline fun MutableMap<String, Any?>.toTableSchemas(): TableSchemas = TableSchemasImpl(this)


inline fun List<Column>.toCells(wrapped: MutableMap<String, Any?>): Cells = CellsImpl(
    columns = this,
    wrapped = wrapped
)

inline fun MutableMap<String, Any?>.toTableRow(columns: List<Column>): Row = RowImpl(columns, this)

inline fun MutableMap<String, Any?>.toNestedTableRow(
    schemas: TableSchemas,
    table: TableSchema
): Row = joyfill2.collection.internal.RowImpl(schemas, table, this)

// Field Position
inline fun MutableMap<String, Any?>.toPosition(): FieldPosition = FieldPositionImpl(this)

// Column
inline fun MutableMap<String, Any?>.toColumnVisualProperties(): ColumnVisualProperties =
    ColumnVisualPropertiesImpl(this)

inline fun MutableMap<String, Any?>.toColumn(): Column = when (type()) {
    Type.text -> TextColumnImpl(this)
    Type.block -> BlockColumnImpl(this)
    Type.textarea -> TextAreaColumnImpl(this)
    Type.dropdown -> DropdownColumnImpl(this)
    Type.barcode -> BarcodeColumnImpl(this)
    Type.number -> NumberColumnImpl(this)
    Type.image -> ImageColumnImpl(this)
    Type.file -> FileColumnImpl(this)
    Type.multiSelect -> MultiSelectColumnImpl(this)
    Type.date -> DateColumnImpl(this)
    Type.signature -> SignatureColumnImpl(this)
    else -> UnknownColumnImpl(this)
}

// Cell
inline fun MutableMap<String, Any?>.toCell(column: Column): Cell = when (column) {
    is TextColumn -> TextCellImpl(column, this)
    is BlockColumn -> BlockCellImpl(column, this)
    is TextAreaColumn -> TextAreaCellImpl(column, this)
    is DropdownColumn -> DropdownCellImpl(column, this)
    is BarcodeColumn -> BarcodeCellImpl(column, this)
    is NumberColumn -> NumberCellImpl(column, this)
    is ImageColumn -> ImageCellImpl(column, this)
    is FileColumn -> FileCellImpl(column, this)
    is SignatureColumn -> SignatureCellImpl(column, this)
    is MultiSelectColumn -> MultiSelectCellImpl(column, this)
    is DateColumn -> DateCellImpl(column, this)
    is UnknownColumn -> UnknownCellImpl(column)
    else -> UnknownCellImpl(column)
}

inline fun MutableMap<String, Any?>.type(): Type {
    val name = try {
        this[ComponentSchema::type.name] as String
    } catch (e: IllegalArgumentException) {
        Type.unknown.name
    }
    return Type.valueOf(name)
}