package joyfill.fields.table.internal

import joyfill.fields.table.MultiselectColumn
import joyfill.utils.JsonList
import joyfill.utils.Option2
import joyfill.utils.toOption

@PublishedApi
internal class MultiselectColumnImpl(wrapped: MutableMap<String, Any?>) : AbstractColumn(wrapped), MultiselectColumn {
    override val options: List<Option2> = JsonList(wrapped[MultiselectColumn::options.name]) { it.toOption() }
    override val value: List<String> get() = wrapped[MultiselectColumn::value.name] as List<String>
    override val multi: Boolean get() = wrapped[MultiselectColumn::multi.name] as Boolean
}