package joyfill.fields.internal

import joyfill.fields.TableField
import joyfill.fields.table.Row
import joyfill.toColumn
import joyfill.toRow
import joyfill.utils.COLUMNS
import joyfill.utils.COLUMN_ORDER
import joyfill.utils.JsonList

@PublishedApi
internal open class TableFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractListBasedField<Row>(wrapped), TableField {

    override fun factory(map: MutableMap<String, Any?>): Row = map.toRow()

    override val columns = JsonList(wrapped[COLUMNS]) { it.toColumn() }

    override val columnsOrder get() = wrapped[COLUMN_ORDER] as MutableList<String>

    override val rowOrder get() = wrapped[TableField::rowOrder.name] as MutableList<String>
}