package joyfill.fields

import joyfill.conditions.Logic
import joyfill.conditions.internal.LogicImpl
import joyfill.fields.internal.ToolTipImpl
import joyfill.type
import joyfill.utils.ID

internal abstract class AbstractField(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Field {
    override var id: String
        get() = wrapped[ID] as String
        set(value) {
            wrapped[ID] = value
        }
    override var title: String
        get() = wrapped[Field::title.name] as String
        set(value) {
            wrapped[Field::title.name] = value
        }
    override var identifier: String
        get() = wrapped[Field::identifier.name] as String
        set(value) {
            wrapped[Field::identifier.name] = value
        }
    override val type: Field.Type get() = wrapped.type()
    override val disabled: Boolean get() = wrapped[Field::disabled.name]?.toString()?.toBoolean() == true
    override var hidden: Boolean
        get() = wrapped[Field::hidden.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Field::hidden.name] = value
        }
    override val required: Boolean get() = wrapped[Field::required.name]?.toString()?.toBoolean() == true

    override val tip by lazy { ToolTipImpl(wrapped) }

    override val logic: Logic? get() = wrapped[Field::logic.name]?.let { LogicImpl(it as MutableMap<String, Any?>) }
}