package joyfill.conditions.internal

import joyfill.conditions.AndEval
import joyfill.conditions.ConditionDefinition
import joyfill.conditions.HideAction
import joyfill.conditions.Logic
import joyfill.conditions.OrEval
import joyfill.conditions.ShowAction
import joyfill.conditions.UnknownAction
import joyfill.conditions.UnknownEval
import joyfill.utils.JsonList

internal class LogicImpl(
    private val wrapped: MutableMap<String, Any?>
) : Logic {
    override val action get() = wrapped[Logic::action.name].toAction()
    override val eval get() = wrapped[Logic::eval.name].toEval()
    override val conditions: MutableList<ConditionDefinition> = run {
        val key = Logic::conditions.name
        if(wrapped[key]==null) {
            wrapped[key] = mutableListOf<MutableMap<String,Any?>>()
        }
        JsonList(wrapped[key]) { ConditionDefinitionImpl(it) }
    }

    override val hidden get() = wrapped[Logic::hidden.name]?.toString()?.toBoolean()

    private fun Any?.toAction() = when (this) {
        "show" -> ShowAction
        "hide" -> HideAction
        else -> UnknownAction(this)
    }

    private fun Any?.toEval() = when (this) {
        "and" -> AndEval
        "or" -> OrEval
        else -> UnknownEval(this)
    }
}