@file:Suppress("NOTHING_TO_INLINE")

package joyfill

import joyfill.fields.BarcodeField
import joyfill.fields.ChartField
import joyfill.fields.DateField
import joyfill.fields.DropdownField
import joyfill.fields.Field
import joyfill.fields.Field.Type.barcode
import joyfill.fields.Field.Type.block
import joyfill.fields.Field.Type.chart
import joyfill.fields.Field.Type.date
import joyfill.fields.Field.Type.dropdown
import joyfill.fields.Field.Type.file
import joyfill.fields.Field.Type.image
import joyfill.fields.Field.Type.multiSelect
import joyfill.fields.Field.Type.number
import joyfill.fields.Field.Type.progress
import joyfill.fields.Field.Type.richText
import joyfill.fields.Field.Type.signature
import joyfill.fields.Field.Type.table
import joyfill.fields.Field.Type.text
import joyfill.fields.Field.Type.textarea
import joyfill.fields.Field.Type.unknown
import joyfill.fields.FileField
import joyfill.fields.ImageField
import joyfill.fields.MultiSelectField
import joyfill.fields.NumberField
import joyfill.fields.SignatureField
import joyfill.fields.TableField
import joyfill.fields.TextAreaField
import joyfill.fields.TextField
import joyfill.fields.UnknownField
import joyfill.fields.VField
import joyfill.fields.chart.Line
import joyfill.fields.chart.Point
import joyfill.fields.chart.internal.LineImpl
import joyfill.fields.chart.internal.PointImpl
import joyfill.fields.internal.BarcodeFieldImpl
import joyfill.fields.internal.BlockFieldImpl
import joyfill.fields.internal.ChartFieldImpl
import joyfill.fields.internal.DateFieldImpl
import joyfill.fields.internal.DropdownFieldImpl
import joyfill.fields.internal.FileFieldImpl
import joyfill.fields.internal.ImageFieldImpl
import joyfill.fields.internal.MultiSelectFieldImpl
import joyfill.fields.internal.NumberFieldImpl
import joyfill.fields.internal.RichTextFieldImpl
import joyfill.fields.internal.SignatureFieldImpl
import joyfill.fields.internal.TableFieldImpl
import joyfill.fields.internal.TextAreaFieldImpl
import joyfill.fields.internal.TextFieldImpl
import joyfill.fields.internal.UnknownFieldImpl
import joyfill.fields.table.Column
import joyfill.fields.table.ColumnPosition
import joyfill.fields.table.Row
import joyfill.fields.table.internal.BarcodeColumnImpl
import joyfill.fields.table.internal.BlockColumnImpl
import joyfill.fields.table.internal.ColumnPositionImpl
import joyfill.fields.table.internal.DateColumnImpl
import joyfill.fields.table.internal.DropDownColumnImpl
import joyfill.fields.table.internal.ImageColumnImpl
import joyfill.fields.table.internal.MultiselectColumnImpl
import joyfill.fields.table.internal.NumberColumnImpl
import joyfill.fields.table.internal.ProgressColumnImpl
import joyfill.fields.table.internal.RowImpl
import joyfill.fields.table.internal.SignatureColumnImpl
import joyfill.fields.table.internal.TextColumnImpl
import joyfill.fields.table.internal.UnknownColumnImpl
import joyfill.internal.DocumentImpl
import joyfill.internal.FieldPositionImpl
import joyfill.internal.FileImpl
import joyfill.internal.PageImpl
import joyfill.utils.toMap
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonArray
import kotlinx.serialization.json.JsonObject

// Document
inline fun MutableMap<String, Any?>.toDocument(): Document = DocumentImpl(this)

inline fun String.toDocuments(): List<Document> = Json.decodeFromString<JsonArray>(this).map {
    (it as JsonObject).toDocument()
}

inline fun String.toDocument(): Document = Json.decodeFromString<JsonObject>(this).toDocument()

inline fun JsonObject.toDocument(): Document = toMap().toDocument()

inline fun Document.toMutableDocument(): MutableDocument = this as MutableDocument

// Page
inline fun MutableMap<String, Any?>.toPage(): Page = PageImpl(this)

inline fun Page.toMutablePage(): MutablePage = this as MutablePage

// File
inline fun MutableMap<String, Any?>.toFile(): File = FileImpl(this)

inline fun File.toMutableFile(): MutableFile = this as MutableFile


// Field Position
inline fun MutableMap<String, Any?>.toPosition(): FieldPosition = FieldPositionImpl(this)

inline fun MutableMap<String, Any?>.toColumnPosition(): ColumnPosition = ColumnPositionImpl(this)

inline fun MutableMap<String, Any?>.toTextField(): TextField = TextFieldImpl(this)

inline fun MutableMap<String, Any?>.toBarcodeField(): BarcodeField = BarcodeFieldImpl(this)

inline fun MutableMap<String, Any?>.toTextAreaField(): TextAreaField = TextAreaFieldImpl(this)

inline fun MutableMap<String, Any?>.toSignatureField(): SignatureField = SignatureFieldImpl(this)

inline fun MutableMap<String, Any?>.toNumberField(): NumberField = NumberFieldImpl(this)


inline fun MutableMap<String, Any?>.toDateField(): DateField = DateFieldImpl(this)

inline fun MutableMap<String, Any?>.toDropdownField(): DropdownField = DropdownFieldImpl(this)

inline fun MutableMap<String, Any?>.toMultiSelectField(): MultiSelectField = MultiSelectFieldImpl(this)

inline fun MutableMap<String, Any?>.toFileField(): FileField = FileFieldImpl(this)

inline fun MutableMap<String, Any?>.toImageField(): ImageField = ImageFieldImpl(this)

inline fun MutableMap<String, Any?>.toRow(): Row = RowImpl(this)

inline fun MutableMap<String, Any?>.toColumn(): Column = when (type()) {
    text -> TextColumnImpl(this)
    block -> BlockColumnImpl(this)
    date -> DateColumnImpl(this)
    number -> NumberColumnImpl(this)
    dropdown -> DropDownColumnImpl(this)
    multiSelect -> MultiselectColumnImpl(this)
    image -> ImageColumnImpl(this)
    barcode -> BarcodeColumnImpl(this)
    signature -> SignatureColumnImpl(this)
    progress -> ProgressColumnImpl(this)
    else -> UnknownColumnImpl(this)
}

inline fun MutableMap<String, Any?>.toTableField(): TableField = TableFieldImpl(this)

inline fun MutableMap<String, Any?>.toUnknownField(): UnknownField = UnknownFieldImpl(this)

inline fun MutableMap<String, Any?>.toPoint(): Point = PointImpl(this)

inline fun MutableMap<String, Any?>.toLine(): Line = LineImpl(this)

inline fun MutableMap<String, Any?>.toChartField(): ChartField = ChartFieldImpl(this)

inline fun MutableMap<String, Any?>.toField(): VField = when (type()) {
    text -> toTextField()
    textarea -> toTextAreaField()
    number -> toNumberField()
    dropdown -> toDropdownField()
    multiSelect -> toMultiSelectField()
    date -> toDateField()
    signature -> toSignatureField()
    image -> toImageField()
    file -> toFileField()
    table -> toTableField()
    chart -> toChartField()
    richText -> RichTextFieldImpl(this)
    block -> BlockFieldImpl(this)
    barcode -> toBarcodeField()
    else -> toUnknownField()
}

inline fun MutableMap<String, Any?>.type(): Field.Type = try {
    Field.Type.valueOf(this[Field::type.name] as String)
} catch (e: IllegalArgumentException) {
    unknown
}