package joyfill2.utils

import joyfill2.Mappable
import joyfill2.utils.internal.AttachmentImpl
import joyfill2.utils.internal.OptionImpl

fun Option(
    id: String,
    value: String,
    deleted: Boolean? = null,
    color: String? = null
): Option = mutableMapOf<String, Any?>(
    ID to id,
    Option::value.name to value,
    Option::deleted.name to deleted,
    Option::color.name to color
).toOption()

fun MutableMap<String, Any?>.toOption(): Option = OptionImpl(this)

private fun RawAttachment(
    id: String,
    url: String,
    fileName: String? = null,
    filePath: String? = null,
    download: String? = null
) = mutableMapOf<String, Any?>(
    ID to id,
    Attachment::url.name to url,
    Attachment::fileName.name to fileName,
    Attachment::filePath.name to filePath,
    Attachment::download.name to download
)

fun Attachment(
    id: String,
    url: String,
    fileName: String? = null,
    filePath: String? = null,
    download: String? = null
): Attachment = RawAttachment(id, url, fileName, filePath, download).toAttachment()

fun MutableMap<String, Any?>.toAttachment(): Attachment = AttachmentImpl(this)

internal fun <T : Mappable> MutableMap<String, Any?>.listOf(
    key: String,
    factory: (MutableMap<String, Any?>) -> T
): MutableList<T> {
    if (this[key] !is MutableList<*>) {
        this[key] = mutableListOf<MutableMap<String, Any?>>()
    }
    return JsonList(this[key], factory)
}