package joyfill2.text_area.internal

import joyfill2.text_area.TextAreaCell
import joyfill2.text_area.TextAreaColumn
import joyfill2.text_area.TextAreaSchema
import joyfill2.utils.toNullableString

@PublishedApi
internal class TextAreaCellImpl(
    override val column: TextAreaColumn,
    private val wrapped: MutableMap<String, Any?>
) : TextAreaCell, TextAreaSchema by column {
    override var value: String?
        get() = wrapped[column.id].toNullableString()
        set(value) {
            wrapped[column.id] = value
        }
}