package joyfill2.table.internal

import joyfill2.conditions.table.TableLogic
import joyfill2.internal.AbstractListBasedField
import joyfill2.table.Column
import joyfill2.table.Row
import joyfill2.table.TableField
import joyfill2.table.TableSchema
import joyfill2.toColumn
import joyfill2.utils.COLUMNS
import joyfill2.utils.COLUMN_ORDER
import joyfill2.utils.JsonList

@PublishedApi
internal open class TableFieldImpl(
    wrapped: MutableMap<String, Any?>,
) : AbstractListBasedField<Row>(wrapped), TableField {

    override fun factory(map: MutableMap<String, Any?>) = RowImpl(columns, map)

    override val columns: MutableList<Column> by lazy {
        JsonList(wrapped[COLUMNS]) { it.toColumn() }
    }

    override val columnsOrder by lazy {
        if (wrapped[COLUMN_ORDER] !is MutableList<*>) {
            wrapped[COLUMN_ORDER] = mutableListOf<String>()
        }
        wrapped[COLUMN_ORDER] as MutableList<String>
    }


    override val rowOrder by lazy {
        if (wrapped[TableField::rowOrder.name] !is MutableList<*>) {
            wrapped[TableField::rowOrder.name] = mutableListOf<String>()
        }
        wrapped[TableField::rowOrder.name] as MutableList<String>
    }

    override var root: Boolean
        get() = wrapped[TableField::root.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[TableField::root.name] = value
        }

    override val tableLogic: TableLogic? = null

    override val children: MutableList<String> by lazy {
        if (wrapped[TableSchema::children.name] !is MutableList<*>) {
            wrapped[TableSchema::children.name] = mutableListOf<String>()
        }
        wrapped[TableSchema::children.name] as MutableList<String>
    }
}