package joyfill2.number.internal

import joyfill2.internal.AbstractValueBasedField
import joyfill2.number.NumberField
import joyfill2.utils.toDouble


@PublishedApi
internal class NumberFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<Double>(wrapped), NumberField {
    override var value: Double?
        get() = wrapped[NumberField::value.name]?.toDouble()
        set(value) {
            wrapped[NumberField::value.name] = value
        }
}

