package joyfill2.internal

import joyfill2.FieldPosition
import joyfill2.utils.COLUMNS
import joyfill2.utils.ID
import joyfill2.utils.JsonList
import joyfill2.table.internal.table.ColumnVisualProperties
import joyfill2.toColumnVisualProperties

@PublishedApi
internal class FieldPositionImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), FieldPosition {
    override val id: String get() = wrapped[ID] as String
    override val field: String get() = wrapped[FieldPosition::field.name] as String
    override val displayType: String? get() = wrapped[FieldPosition::displayType.name] as? String
    override val y get() = wrapped[FieldPosition::y.name]?.toString()?.toDouble() ?: 0.0
    override val x get() = wrapped[FieldPosition::x.name]?.toString()?.toDouble() ?: 0.0
    override val format get() = wrapped[FieldPosition::format.name] as? String
    override val fontColor: String? get() = wrapped[FieldPosition::fontColor.name] as? String
    override val fontWeight: String? get() = wrapped[FieldPosition::fontWeight.name] as? String
    override val fontSize: Double? get() = wrapped[FieldPosition::fontSize.name]?.toString()?.toDouble()
    override val textTransform: String? get() = wrapped[FieldPosition::textTransform.name] as? String
    override val textOverflow: String? get() = wrapped[FieldPosition::textOverflow.name] as? String
    override val textAlign: String? get() = wrapped[FieldPosition::textAlign.name] as? String
    override val type: String get() = wrapped[FieldPosition::type.name] as String
    override val borderColor: String? get() = wrapped[FieldPosition::borderColor.name] as? String
    override val backgroundColor: String? get() = wrapped[FieldPosition::backgroundColor.name] as? String
    override val borderRadius: Double? get() = wrapped[FieldPosition::borderRadius.name]?.toString()?.toDouble()
    override val borderWidth: Double? get() = wrapped[FieldPosition::borderWidth.name]?.toString()?.toDouble()
    override val padding: Double? get() = wrapped[FieldPosition::padding.name]?.toString()?.toDouble()
    override val titleDisplay: String? get() = wrapped[FieldPosition::titleDisplay.name] as? String
    override val fontStyle: String? get() = wrapped[FieldPosition::fontStyle.name] as? String
    override val textDecoration: String? get() = wrapped[FieldPosition::textDecoration.name] as? String
    override val columns: List<ColumnVisualProperties> by lazy {
        val data = wrapped[COLUMNS] as? MutableList<MutableMap<String, Any?>> ?: mutableListOf()
        JsonList(data) { it.toColumnVisualProperties() }
    }
}