package joyfill2.conditions.internal

import joyfill2.conditions.Condition
import joyfill2.conditions.ConditionDefinition
import joyfill2.conditions.Contains
import joyfill2.conditions.Empty
import joyfill2.conditions.Equals
import joyfill2.conditions.Filled
import joyfill2.conditions.GreaterThan
import joyfill2.conditions.LessThan
import joyfill2.conditions.NotEquals
import joyfill2.conditions.UnknownConditionOperator
import joyfill2.internal.AbstractMappable

@PublishedApi
internal abstract class AbstractConditionDefinitionImpl(
    wrapped: MutableMap<String, Any?>
): AbstractMappable(wrapped), ConditionDefinition {
    override val value by lazy { wrapped[ConditionDefinition::value.name] }

    override val condition by lazy {
        wrapped[ConditionDefinition::condition.name].toOperator()
    }

    private fun Any?.toOperator() = when (this) {
        Condition.Filled.notation -> Filled
        Condition.Empty.notation -> Empty
        Condition.Equals.notation -> Equals
        Condition.NotEquals.notation -> NotEquals
        Condition.Contains.notation -> Contains
        Condition.GreaterThan.notation -> GreaterThan
        Condition.LessThan.notation -> LessThan
        else -> UnknownConditionOperator(this)
    }
}
