package joyfill2.collection.internal

import joyfill2.collection.Child
import joyfill2.collection.Children
import joyfill2.collection.TableSchemas
import joyfill2.internal.AbstractMappable
import joyfill2.table.TableSchema

@PublishedApi
internal class ChildrenImpl(
    private val schema: TableSchemas,
    private val table: TableSchema,
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Children {

    private val cache by lazy { mutableMapOf<String, Child>() }

    override fun find(key: String?): Child? = schema.table(key)?.toChild()

    override fun all(): List<Child> = schema.all().filter { it.id in table.children }.map { it.toChild() }

    private fun TableSchema.toChild(): Child = cache.getOrPut(id) {
        if (wrapped[id] == null) {
            wrapped[id] = mutableMapOf<String, Any?>()
        }
        ChildImpl(schema, this, wrapped[id] as MutableMap<String, Any?>)
    }
}