package joyfill.fields.table.internal

import joyfill.fields.table.DropdownColumn
import joyfill.fields.table.TextColumn
import joyfill.utils.JsonList
import joyfill.utils.Option2
import joyfill.utils.toOption

@PublishedApi
internal class DropDownColumnImpl(wrapped: MutableMap<String, Any?>) : AbstractColumn(wrapped), DropdownColumn {
    override val options: List<Option2> = JsonList(wrapped[DropdownColumn::options.name]) { it.toOption() }
    override val value: String? get() = wrapped[TextColumn::value.name] as? String
}