package joyfill.fields.internal

import joyfill.Mappable
import joyfill.fields.AbstractField
import joyfill.fields.ListBasedField
import joyfill.utils.JsonList

@PublishedApi
internal abstract class AbstractListBasedField<V : Mappable>(
    wrapped: MutableMap<String, Any?>
) : AbstractField(wrapped), ListBasedField<V> {
    abstract fun factory(map: MutableMap<String, Any?>): V
    override val value: MutableList<V> = run {
        val key = ListBasedField<*>::value.name
        val item = wrapped[key]
        if (item !is List<*>) {
            wrapped[key] = mutableListOf<MutableMap<String, Any>>()
        }
        return@run JsonList(wrapped[key]) { factory(it) }
    }
}