package joyfill2.table.internal.column

import joyfill2.Field
import joyfill2.Type
import joyfill2.schemas.internal.AbstractSchema
import joyfill2.table.Column
import joyfill2.type
import joyfill2.utils.ID

abstract class AbstractColumn(
    wrapped: MutableMap<String, Any?>
) : AbstractSchema(wrapped), Column {

    override var id: String
        get() = wrapped[ID] as String
        set(value) {
            wrapped[ID] = value
        }

    override var title: String
        get() = wrapped[Column::title.name] as String
        set(value) {
            wrapped[Column::title.name] = value
        }

    override var type: Type
        get() = wrapped.type()
        set(value) {
            wrapped[Column::type.name] = value
        }

    override var required: Boolean
        get() = wrapped[Column::required.name]?.toString()?.lowercase()?.toBooleanStrictOrNull() == true
        set(value) {
            wrapped[Column::required.name] = value
        }

    override var hidden: Boolean
        get() = wrapped[Field::hidden.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Field::hidden.name] = value
        }
}