package joyfill2.table.internal

import joyfill2.table.Row
import joyfill2.table.TableComponent
import joyfill2.table.TableSchema
import joyfill2.value.ListValue

class TableComponentImpl(
    private val container: ListValue<Row>,
    private val schema: TableSchema,
) : TableComponent, TableSchema by schema {
    override var identifier = schema.id
    override val columnsOrder get() = schema.columns.map { it.id }.toMutableList()
    override val rowOrder get() = value.map { it.id }.toMutableList()
    override val value by lazy { container.value }
}