package joyfill2.table

import joyfill2.barcode.BarcodeCell
import joyfill2.date.DateCell
import joyfill2.dropdown.DropdownCell
import joyfill2.file.FileCell
import joyfill2.image.ImageCell
import joyfill2.multi_select.MultiSelectCell
import joyfill2.number.NumberCell
import joyfill2.signature.SignatureCell
import joyfill2.text.TextCell
import joyfill2.text.TextColumn
import joyfill2.text_area.TextAreaCell

interface CellFinder : Finder<Cell> {
    /**
     * Finds a [Cell] by key
     * @param key can be the [Column.id] or [Column.title] of the particular [Cell]
     * @return the [Cell] if found, null otherwise
     */
    override fun find(key: String?): Cell?


    /**
     * Finds a [TextCell] by key
     * @param key can be the [TextColumn.id] or [TextColumn.title] of the particular [Cell]
     * @return the [Cell] if a [TextCell] is found, null otherwise
     */
    override fun text(key: String?): TextCell?

    override fun dropdown(key: String?): DropdownCell?

    override fun textArea(key: String?): TextAreaCell?

    override fun barcode(key: String?): BarcodeCell?

    override fun number(key: String?): NumberCell?

    override fun date(key: String?): DateCell?

    override fun image(key: String?): ImageCell?

    override fun file(key: String?): FileCell?

    override fun multiSelect(key: String?): MultiSelectCell?

    override fun signature(key: String?): SignatureCell?
}

