package joyfill2.signature.internal

import joyfill2.signature.SignatureCell
import joyfill2.signature.SignatureColumn
import joyfill2.signature.SignatureSchema

@PublishedApi
internal class SignatureCellImpl(
    override val column: SignatureColumn,
    private val wrapped: MutableMap<String, Any?>
) : SignatureCell, SignatureSchema by column {
    override var value: String?
        get() = wrapped[column.id] as? String
        set(value) {
            wrapped[column.id] = value
        }
}