package joyfill2.multi_select.internal

import joyfill2.multi_select.MultiSelectCell
import joyfill2.multi_select.MultiSelectColumn
import joyfill2.multi_select.MultiSelectSchema

@PublishedApi
internal class MultiSelectCellImpl(
    override val column: MultiSelectColumn,
    private val wrapped: MutableMap<String, Any?>
) : MultiSelectCell, MultiSelectSchema by column {
    override val value: MutableList<String> = run {
        val key = column.id
        val v = wrapped[key] as? MutableList<String>
        if (v == null) {
            wrapped[key] = mutableListOf<String>()
        }
        wrapped[key] as MutableList<String>
    }
}