package joyfill2.internal

import joyfill2.Page
import joyfill2.View
import joyfill2.toPage
import joyfill2.utils.ID
import joyfill2.utils.JsonList

@PublishedApi
internal class ViewImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), View {
    override val id: String get() = wrapped[ID] as String
    override val type: String = wrapped[View::type.name] as String
    override val pages: MutableList<Page> = run {
        val key = View::pages.name
        if (wrapped[key] == null) {
            wrapped[key] = mutableListOf<MutableMap<String, Any?>>()
        }
        JsonList(wrapped[key]) { it.toPage() }
    }
    override val pageOrder: MutableList<String> = run {
        val key = View::pageOrder.name
        if (wrapped[key] == null) {
            wrapped[key] = mutableListOf<String>()
        }
        wrapped[key] as MutableList<String>
    }

}