package joyfill2.internal

import joyfill2.FieldPosition
import joyfill2.Page
import joyfill2.conditions.Logic
import joyfill2.conditions.internal.AbstractLogicImpl
import joyfill2.Field
import joyfill2.conditions.internal.field.FieldLogicImpl
import joyfill2.toPosition
import joyfill2.utils.ID
import joyfill2.utils.JsonList
import joyfill2.utils.POSITIONS

@PublishedApi
internal class PageImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), Page {
    override var id: String
        get() = wrapped[ID] as String
        set(value) {
            wrapped[ID] = value
        }
    override var name: String
        get() = wrapped[Page::name.name] as String
        set(value) {
            wrapped[Page::name.name] = value
        }

    override var identifier: String
        get() = wrapped[Field::identifier.name]?.toString() ?: ""
        set(value) {
            wrapped[Field::identifier.name] = value
        }

    override val positions: MutableList<FieldPosition> = JsonList(wrapped[POSITIONS]) { it.toPosition() }


    override var logic: Logic?
        get() = wrapped[Page::logic.name]?.let { FieldLogicImpl(it as MutableMap<String, Any?>) }
        set(value) {
            wrapped[Page::logic.name] = value
        }

    override var hidden: Boolean
        get() = wrapped[Page::hidden.name]?.toString()?.toBoolean() == true
        set(value) {
            wrapped[Page::hidden.name] = value
        }

    override fun toString(): String = "Page(name = $name, hidden = $hidden)"
}