package joyfill2.internal

import joyfill2.Mappable
import joyfill2.components.Component
import joyfill2.utils.JsonList

@PublishedApi
internal abstract class AbstractListBasedField<V : Mappable>(
    wrapped: MutableMap<String, Any?>
) : AbstractField(wrapped), Component {
    abstract fun factory(map: MutableMap<String, Any?>): V
    override val value: MutableList<V> = run {
        val key = Component::value.name
        val item = wrapped[key]
        if (item !is List<*>) {
            wrapped[key] = mutableListOf<MutableMap<String, Any>>()
        }
        return@run JsonList(wrapped[key]) { factory(it) }
    }
}