package joyfill2.date.internal

import joyfill2.date.DateCell
import joyfill2.date.DateColumn
import joyfill2.date.DateSchema

@PublishedApi
internal class DateCellImpl(
    override val column: DateColumn,
    private val wrapped: MutableMap<String, Any?>
) : DateCell, DateSchema by column {
    override var value: Long?
        get() = wrapped[column.id] as? Long
        set(value) {
            wrapped[column.id] = value
        }
}