package joyfill2.barcode.internal

import joyfill2.barcode.BarcodeCell
import joyfill2.barcode.BarcodeColumn
import joyfill2.barcode.BarcodeSchema

@PublishedApi
internal class BarcodeCellImpl(
    override val column: BarcodeColumn,
    private val wrapped: MutableMap<String, Any?>
) : BarcodeCell, BarcodeSchema by column {
    override var value: String?
        get() = wrapped[column.id] as? String
        set(value) {
            wrapped[column.id] = value
        }
}

