package joyfill.utils.internal

import joyfill.fields.AbstractMappable
import joyfill.utils.ID
import joyfill.utils.Option2

internal class OptionImpl(wrapped: MutableMap<String, Any?>) : AbstractMappable(wrapped), Option2 {
    override val id: String get() = wrapped[ID] as String
    override val deleted: Boolean get() = (wrapped[Option2::deleted.name] as? Boolean) == true
    override val value: String get() = wrapped[Option2::value.name] as String
    override val color: String? get() = wrapped[Option2::color.name] as? String

    override fun equals(other: Any?): Boolean = other is Option2 && id == other.id
}