package joyfill.fields.table.internal

import joyfill.fields.AbstractMappable
import joyfill.fields.table.Row
import joyfill.utils.ID

@PublishedApi
internal class RowImpl(wrapped: MutableMap<String, Any?>) : AbstractMappable(wrapped), Row {
    override val id: String get() = wrapped[ID] as String
    override val cells: MutableMap<String, Any?> = when (val cellsValue = wrapped[Row::cells.name]) {
        is MutableMap<*, *> -> cellsValue as MutableMap<String, Any?>
        else -> mutableMapOf()
    }
    override val deleted: Boolean get() = wrapped[Row::deleted.name] as? Boolean == true
}