package joyfill.fields.internal

import joyfill.fields.ChartField
import joyfill.fields.chart.Axis
import joyfill.fields.chart.Line
import joyfill.toLine
import joyfill.utils.AXIS_X_MAX
import joyfill.utils.AXIS_X_MIN
import joyfill.utils.AXIS_X_TITLE
import joyfill.utils.AXIS_Y_MAX
import joyfill.utils.AXIS_Y_MIN
import joyfill.utils.AXIS_Y_TITLE

@PublishedApi
internal open class ChartFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractListBasedField<Line>(wrapped), ChartField {

    override fun factory(map: MutableMap<String, Any?>): Line = map.toLine()

    override val y: Axis by lazy { YAxis() }

    override val x: Axis by lazy { XAxis() }

    inner class YAxis : Axis {
        override var label: String
            get() = wrapped[AXIS_Y_TITLE] as String
            set(value) {
                wrapped[AXIS_Y_TITLE] = value
            }
        override var min: Double
            get() = wrapped[AXIS_Y_MIN] as? Double ?: 0.0
            set(value) {
                wrapped[AXIS_Y_MIN] = value
            }
        override var max: Double
            get() = wrapped[AXIS_Y_MAX] as? Double ?: 100.0
            set(value) {
                wrapped[AXIS_Y_MAX] = value
            }
    }

    inner class XAxis : Axis {
        override var label: String
            get() = wrapped[AXIS_X_TITLE] as String
            set(value) {
                wrapped[AXIS_X_TITLE] = value
            }
        override var min: Double
            get() = wrapped[AXIS_X_MIN] as? Double ?: 0.0
            set(value) {
                wrapped[AXIS_X_MIN] = value
            }
        override var max: Double
            get() = wrapped[AXIS_X_MAX] as? Double ?: 100.0
            set(value) {
                wrapped[AXIS_X_MAX] = value
            }
    }
}