package joyfill.fields.chart.internal

import joyfill.fields.AbstractMappable
import joyfill.fields.chart.Line
import joyfill.fields.chart.Point
import joyfill.toPoint
import joyfill.utils.ID
import joyfill.utils.JsonList


@PublishedApi
internal class LineImpl(wrapped: MutableMap<String, Any?>) : AbstractMappable(wrapped), Line {
    override val id get() = wrapped[ID] as String

    override var title: String
        get() = wrapped[Line::title.name] as String
        set(value) {
            wrapped[Line::title.name] = value
        }

    override var description: String?
        get() = wrapped[Line::description.name] as? String
        set(value) {
            wrapped[Line::description.name] = value
        }

    override val points: MutableList<Point> = run {
        val key = Line::points.name
        val value = wrapped[key]
        if (value == null) {
            wrapped[key] = mutableListOf<MutableMap<String, Any>>()
        }
        JsonList(wrapped[key]) { it.toPoint() }
    }
}