package joyfill.fields

import joyfill.Mappable
import joyfill.ToolTip
import joyfill.conditions.Logic

sealed interface Field : Mappable {
    var id: String
    var title: String
    var identifier: String
    val type: Type
    val logic: Logic?
    val disabled: Boolean
    val required: Boolean
    var hidden: Boolean
    val tip: ToolTip

    enum class Type {
        text,
        textarea,
        number,
        dropdown,
        multiSelect,
        date,
        richText,
        signature,
        table,
        chart,
        image,
        file,
        block,
        progress,
        barcode,
        unknown
    }
}