package joyfill.utils

import joyfill.Mappable
import joyfill.utils.internal.AttachmentImpl
import joyfill.utils.internal.OptionImpl

fun Option(
    id: String,
    value: String,
    deleted: Boolean? = null
): Option2 = mutableMapOf<String, Any?>(
    ID to id,
    Option2::value.name to value,
    Option2::deleted.name to deleted
).toOption()

fun MutableMap<String, Any?>.toOption(): Option2 = OptionImpl(this)

fun RawAttachment(
    id: String,
    url: String,
    fileName: String? = null,
    filePath: String? = null,
    download: String? = null
) = mutableMapOf<String, Any?>(
    ID to id,
    Attachment::url.name to url,
    Attachment::fileName.name to fileName,
    Attachment::filePath.name to filePath,
    Attachment::download.name to download
)

fun Attachment(
    id: String,
    url: String,
    fileName: String? = null,
    filePath: String? = null,
    download: String? = null
): Attachment = RawAttachment(id, url, fileName, filePath, download).toAttachment()

fun MutableMap<String, Any?>.toAttachment(): Attachment = AttachmentImpl(this)

internal fun <T : Mappable> MutableMap<String, Any?>.listOf(
    key: String,
    factory: (MutableMap<String, Any?>) -> T
): List<T> {
    if (this[key] == null) {
        this[key] = mutableListOf<MutableMap<String, Any?>>()
    }
    return JsonList(this[key], factory)
}