package joyfill.internal

import joyfill.FieldPosition
import joyfill.fields.AbstractMappable
import joyfill.utils.ID

@PublishedApi
internal class FieldPositionImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), FieldPosition {
    override val id: String get() = wrapped[ID] as String
    override val field: String get() = wrapped[FieldPosition::field.name] as String
    override val displayType: String? get() = wrapped[FieldPosition::displayType.name] as? String
    override val y get() = wrapped[FieldPosition::y.name]?.toString()?.toDouble() ?: 0.0
    override val x get() = wrapped[FieldPosition::x.name]?.toString()?.toDouble() ?: 0.0
    override val format get() = wrapped[FieldPosition::format.name] as? String
    override val fontColor: String? get() = wrapped[FieldPosition::fontColor.name] as? String
    override val fontWeight: String? get() = wrapped[FieldPosition::fontWeight.name] as? String
    override val fontSize: Double? get() = wrapped[FieldPosition::fontSize.name]?.toString()?.toDouble()
    override val textTransform: String? get() = wrapped[FieldPosition::textTransform.name] as? String
    override val textOverflow: String? get() = wrapped[FieldPosition::textOverflow.name] as? String
    override val textAlign: String? get() = wrapped[FieldPosition::textAlign.name] as? String
}