package joyfill.fields.table.internal

import joyfill.fields.table.ImageColumn
import joyfill.utils.Attachment
import joyfill.utils.JsonList
import joyfill.utils.toAttachment

@PublishedApi
internal class ImageColumnImpl(wrapped: MutableMap<String, Any?>) : AbstractColumn(wrapped), ImageColumn {
    override val value: MutableList<Attachment> = run {
        val key = ImageColumn::value.name
        if (wrapped[key] == null) {
            wrapped[key] = mutableListOf<MutableMap<String, Any?>>()
        }
        JsonList(wrapped[key]) { it.toAttachment() }
    }
}