package joyfill.fields.table

import joyfill.Mappable
import joyfill.fields.Field
import joyfill.utils.Attachment
import joyfill.utils.Option2

interface Column : Mappable {
    val id: String
    val title: String
    val type: Field.Type
}

interface TextColumn : Column {
    val value: String?
}

interface DropdownColumn : Column {
    val options: List<Option2>
    val value: String?
}

interface ImageColumn : Column {
    val value: List<Attachment>
}