package joyfill.fields.internal

import joyfill.fields.SignatureField
import joyfill.fields.TextAreaField
import joyfill.utils.toNullableString

@PublishedApi
internal class SignatureFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<String>(wrapped), SignatureField {
    override var value: String?
        get() = wrapped[SignatureField::value.name]?.toNullableString()
        set(value) {
            wrapped[SignatureField::value.name] = value
        }
}