package joyfill.fields.internal

import joyfill.fields.DateField

@PublishedApi
internal open class DateFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<Long>(wrapped), DateField {
    override var value: Long?
        get() = wrapped[DateField::value.name]?.toString()?.toLongOrNull()
        set(value) {
            wrapped[DateField::value.name] = value
        }
    override val format: String? get() = wrapped["format"] as String?
}