package joyfill.fields.internal

import joyfill.fields.BarcodeField
import joyfill.utils.toNullableString

@PublishedApi
internal class BarcodeFieldImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractValueBasedField<String>(wrapped), BarcodeField {
    override var value: String?
        get() = wrapped[BarcodeField::value.name]?.toNullableString()
        set(value) {
            wrapped[BarcodeField::value.name] = value
        }
}