package joyfill.internal

import joyfill.ChangeEvent
import joyfill.ChangeLog
import joyfill.Document
import joyfill.fields.AbstractMappable
import joyfill.toChangeLog
import joyfill.toDocument
import joyfill.utils.JsonList
import joyfill.utils.toJsonObject
import kotlinx.serialization.json.Json
import kotlinx.serialization.json.JsonObject

internal class ChangeEventImpl(
    wrapped: MutableMap<String, Any?>
) : AbstractMappable(wrapped), ChangeEvent {

    override val changelogs: List<ChangeLog> = JsonList(wrapped[ChangeEvent::changelogs.name]) { it.toChangeLog() }

    override val document: Document = (wrapped[ChangeEvent::document.name] as MutableMap<String, Any?>).toDocument()

    override fun toMap() = wrapped

    override fun toJsonString(): String = Json.encodeToString(toJsonObject())

    override fun toJsonObject(): JsonObject = wrapped.toJsonObject()
}