package joyfill.table

import cinematic.Live
import joyfill.fields.table.Column
import joyfill.utils.Option2

interface ColumnCollection {
    val state: Live<ColumnState>

    fun all() : List<Column>

    /**
     * Looks for a column and returns it.
     * @param key the title or id of the column to find
     * @return the column or null if the column was not found
     */
    fun find(key: String?): Column?

    /**
     * Selects a column and returns it.
     * @param key the title or id of the column to select
     * @return the selected column or null if the column was not selectable
     */
    fun select(key: String?): Column?

    /**
     * Selects a column and returns it.
     * @param column the column to select
     * @return the selected [column] or null if the [column] was not selectable
     */
    fun select(column: Column?): Column?

    fun filter(key: String?)

    fun filter(option: Option2?)

    fun clearFilter()

    fun areFiltersApplied() : Boolean

    fun sort(option: SortingOption?)

    fun sort()
}