package joyfill.editors.internal

import joyfill.Document
import joyfill.EventDispatcher
import joyfill.collections.PageCollection
import joyfill.editors.RichTextFieldEditor
import joyfill.fields.RichTextField
import joyfill.validation.FieldValid

@PublishedApi
internal open class RichTextFieldEditorImpl(
    document: Document,
    override val field: RichTextField,
    pages: PageCollection,
    dispatcher: EventDispatcher,
) : AnyFieldEditor<RichTextField>(document, field, pages, dispatcher, null), RichTextFieldEditor {
    override fun validate() = FieldValid(field, emptyList())
}