package joyfill.table.internal

import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.editors.internal.TableFieldEditorImpl
import joyfill.fields.table.DropdownColumn
import joyfill.fields.table.Row
import joyfill.table.DropdownCellEditor
import joyfill.utils.Option2

internal class DropdownCellEditorImpl(
    document: Document,
    table: TableFieldEditorImpl,
    override val column: DropdownColumn,
    override val row: Row,
    onChange: ((ChangeEvent) -> Unit)?
) : AbstractCellEditor(document, table, onChange), DropdownCellEditor {

    override val options: List<Option2> = column.options

    override val option = mutableLiveOf(read())

    private fun read(): Option2? = find(row.cells[column.id] as? String)

    private fun find(key: String?) = options.find { it.id == key || it.value == key }

    override fun doesNotHaveValue(): Boolean {
        val value = row.cells[column.id] as? String ?: return true
        return value.isEmpty()
    }

    override fun select(key: String?) {
        val o = find(key) ?: return
        option.value = o
        row.cells[column.id] = o.id
        validate()
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }

    override fun select(option: Option2?) = select(option?.id)

    override fun selected(): Option2? = find(row.cells[column.id] as? String)

    override fun unselect(option: Option2?) = unselect(key = option?.id)

    override fun unselect() {
        row.cells[column.id] = null
        option.value = null
        validate()
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }

    override fun unselect(key: String?) {
        find(key) ?: return
        unselect()
    }
}