package joyfill.table.internal

import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.editors.internal.TableFieldEditorImpl
import joyfill.fields.table.Row
import joyfill.fields.table.TextColumn
import joyfill.table.TextCellEditor

internal class TextCellEditorImpl(
    document: Document,
    table: TableFieldEditorImpl,
    override val column: TextColumn,
    override val row: Row,
    onChange: ((ChangeEvent) -> Unit)?
) : AbstractCellEditor(document, table, onChange), TextCellEditor {

    override val text by lazy { mutableLiveOf(row.cells[column.id] as? String) }

    override fun set(value: String?) {
        text.value = value
        row.cells[column.id] = value
        validate()
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }

    override fun doesNotHaveValue(): Boolean {
        val value = row.cells[column.id] as? String ?: return true
        return value.isBlank()
    }
}