package joyfill.editors

import joyfill.Document
import joyfill.JoyStage
import joyfill.Mappable
import joyfill.Validation
import joyfill.View
import joyfill.collections.FieldCollection
import joyfill.collections.PageCollection
import joyfill.validation.DocumentValidity

interface DocumentEditor : Mappable {

    var stage: JoyStage

    var name: String

    var id: String

    var identifier: String

    val fields: FieldCollection

    val views: List<View>

    val pages: PageCollection

    fun set(key: String, value: Any?)

    fun <R> get(key: String): R

    fun integrity(): Validation

    @Deprecated(
        message = "In favour of ValidateDocument",
        replaceWith = ReplaceWith("validateDocument()"),
        level = DeprecationLevel.WARNING // Stage 1: When this is removed, rename validateDocument back to validate for consistency
    )
    fun validate(): Validation

    // To be renamed to validate() after deprecation cycle of validate() ends
    fun validateDocument(): DocumentValidity

    fun resolveConditions()

    fun toDocument(): Document
}