package joyfill.editors.internal

import joyfill.ChangeEvent
import joyfill.Document
import joyfill.EventDispatcher
import joyfill.collections.PageCollection
import joyfill.editors.DropdownFieldEditor
import joyfill.fields.DropdownField
import joyfill.utils.Option2
import joyfill.validation.FieldInvalid
import joyfill.validation.FieldValid
import joyfill.validation.FieldValidity

@PublishedApi
internal class DropdownFieldEditorImpl(
    document: Document,
    override val field: DropdownField,
    pages: PageCollection,
    dispatcher: EventDispatcher,
    onChange: ((ChangeEvent) -> Unit)?
) : AnyFieldEditor<DropdownField>(document, field, pages, dispatcher, onChange), DropdownFieldEditor {
    override val options: List<Option2> get() = this.field.options

    private fun look(key: String?): Option2? = field.options.firstOrNull { it.id == key || it.value == key }

    override fun selected(): Option2? = look(field.value)

    override fun select(key: String?) {
        val option = look(key) ?: return
        if (field.value == option.id) return
        field.value = option.id
        resolveConditions()
        notifyChange(option.value)
    }

    override fun select(option: Option2?) = select(option?.id)

    override fun unselect(option: Option2?) = unselect(key = option?.id)

    override fun unselect() {
        field.value = null
        resolveConditions()
        notifyChange(null)
    }

    override fun unselect(key: String?) {
        val option = look(key) ?: return
        if (field.value != option.id) return
        field.value = null
        resolveConditions()
        notifyChange(null)
    }

    override fun validate(): FieldValidity {
        if (hidden.value || !field.required) return FieldValid(field, emptyList())
        if (field.required && field.value.isNullOrBlank()) return FieldInvalid(field, listOf("Field ${field.title} is required"))
        return FieldValid(field, emptyList())
    }
}