package joyfill.chart.internal

import cinematic.MutableLive
import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.IdentityGenerator
import joyfill.chart.LineCollection
import joyfill.chart.LineEditor
import joyfill.editors.internal.EventTrigger
import joyfill.fields.ChartField
import joyfill.fields.chart.Line
import joyfill.toLine
import joyfill.utils.ID

@PublishedApi
internal class LineCollectionImpl(
    document: Document,
    val identity: IdentityGenerator,
    field: ChartField,
    onChange: ((ChangeEvent) -> Unit)?
) : EventTrigger<ChartField>(document, field, onChange), LineCollection {

    override fun all(): List<LineEditor> = field.value.map { editor(it) }

    private fun look(key: String): Line? = field.value.find { it.id == key || it.title == key }

    override val current: MutableLive<List<LineEditor>> by lazy { mutableLiveOf(all()) }

    override fun find(key: String): LineEditor? {
        val line = look(key) ?: return null
        return editor(line)
    }

    private val cache = mutableMapOf<String, LineEditor>()
    private fun editor(line: Line) = cache.getOrPut(line.id) { LineEditorImpl(identity, line) }

    override fun add(
        title: String,
        id: String?,
        description: String?
    ): LineEditor {
        val line = mutableMapOf<String, Any?>(
            ID to identity.generate(),
            Line::title.name to title,
            Line::description.name to description
        ).toLine()
        field.value.add(line)
        val e = editor(line)
        notifyChange(field.value.map { it.toMap() }.toMutableList())
        current.value += e
        return e
    }

    override fun remove(key: String): Line? {
        val line = look(key) ?: return null
        val e = editor(line)
        field.value.remove(line)
        current.value -= e
        return line
    }
}