package joyfill.table.internal

import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.editors.internal.TableFieldEditorImpl
import joyfill.fields.table.MultiselectColumn
import joyfill.fields.table.Row
import joyfill.table.MultiselectCellEditor
import joyfill.utils.Option2

internal class MultiselectCellEditorImpl(
    document: Document,
    table: TableFieldEditorImpl,
    override val column: MultiselectColumn,
    override val row: Row,
    onChange: ((ChangeEvent) -> Unit)?
) : AbstractCellEditor(document, table, onChange), MultiselectCellEditor {

    override val options: List<Option2> = column.options

    override val value = mutableLiveOf(read())

    private fun read(): List<Option2> = find(row.cells[column.id] as? List<String>)

    private fun find(keys: List<String>?) = options.filter { keys?.contains(it.id) == true  }

    override fun doesNotHaveValue(): Boolean = value.value.isEmpty()

    override fun selectKeys(keys: List<String>) {
        val o = find(keys)
        value.value = o
        row.cells[column.id] = o.map { it.id }
        validate()
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }

    override fun selectOptions(options: List<Option2>) = selectKeys(options.map { it.id })

    override fun selected(): List<Option2> = find(row.cells[column.id] as? List<String>)

    override fun unselectOptions(options: List<Option2>) = unselectKeys(keys = options.map { it.id })

    override fun unselectAll() {
        row.cells[column.id] = null
        value.value = listOf()
        validate()
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }

    override fun unselectKeys(keys: List<String>) {
        val o = find(keys)
        value.value = value.value.filter { it !in o }
        row.cells[column.id] = value.value.map { it.id }
        validate()
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }
}