package joyfill.table.internal

import cinematic.mutableLiveOf
import joyfill.ChangeEvent
import joyfill.Document
import joyfill.editors.internal.TableFieldEditorImpl
import joyfill.fields.table.BlockColumn
import joyfill.fields.table.Row
import joyfill.table.BlockCellEditor

internal class BlockCellEditorImpl(
    document: Document,
    table: TableFieldEditorImpl,
    override val column: BlockColumn,
    override val row: Row,
    onChange: ((ChangeEvent) -> Unit)?
) : AbstractCellEditor(document, table, onChange), BlockCellEditor {

    override val blockText by lazy { mutableLiveOf(row.cells[column.id] as? String) }

    override fun set(value: String?) {
        blockText.value = value
        row.cells[column.id] = value
        notifyChange(field.value.map { it.toMap() }.toMutableList())
    }

    override fun doesNotHaveValue(): Boolean {
        val value = row.cells[column.id] as? String ?: return true
        return value.isBlank()
    }
}